clear;
seed = 123;
rng(seed,'twister');

% minimize ||A'-D'*C'||_F^2/(2*n')+y*(||A-D'*C||_F^2/(2*n)-delta)
% ||C'||_*<=r, ||d'_i||<=r, for i = 1,...,q

% Input data
n = 5e2;
p = 50;
m = 1e2;
u = randn(p,5);
v = randn(n,5);
global A_u A_l X_l;
X_l = u*v'/(norm(u)*norm(v)); % coefficient matrix C
D_l = randn(m,p); % dictionary matrix D
D_l = D_l./sqrt(sum_square(D_l));
A_l = D_l*X_l; % old dataset with known dictionary D and coefficient C
n_u = 1e3;
A_u = randn(m,n_u); % new dataset A'
q = 1.2*p;
X_l = [X_l;zeros(q-p,n)];
delta = 1e-4;

% objective function of saddle point problem
func = @(D,X,y) norm(A_u-D*X,'fro')^2/(2*n_u)+y*(norm(A_l-D*X_l,'fro')^2/(2*n)-delta);
% gradient with respect to y
grady = @(D,X,y) norm(A_l-D*X_l,'fro')^2/(2*n)-delta;

r = 5;
maxiter = 1e3;
B = 1;

% Initialization 
D0 = rand(m,q)/10;
D0 = D0./sqrt(sum_square(D0));
X0 = sparse(q,n_u);
y0 = 0;

%% R-PDCG algorithm (LMO-LMO)
param.maxiter = maxiter;
param.tau = 10/maxiter^(5/6); % primal stepsize
param.mu = 0.001/maxiter^(1/6); % regularization parameter
param.delta = delta;
param.r = r;
param.B = B;
[Gapz1,infeas1,time1,X1,D1,y1] = RPDCG(@gradX,@gradD,grady,X0,D0,y0,param);
figure(1);
set(0,'defaulttextinterpreter','latex');
set(gcf,'DefaultLineLinewidth',2);
set(gcf,'DefaultLineMarkerSize',2);
grid on;
semilogy(time1,Gapz1,'DisplayName','R-PDCG','color', 'blue');
ylabel('$\mathcal{G}_Z(x_k,y_k)$')
xlabel('time(s)')
figure(2);
%set(0,'defaulttextinterpreter','latex');
set(gcf,'DefaultLineLinewidth',2);
set(gcf,'DefaultLineMarkerSize',2);
grid on;
semilogy(time1,infeas1,'DisplayName','R-PDCG','color', 'blue');
ylabel('Infeasibility')
xlabel('time(s)')

%% CG-RPGA algorithm (LMO-PO)
param.tau = 10/maxiter^(3/4); % primal stepsize
param.mu = 0.001/maxiter^(1/4); % regularization parameter
[Gapz2,infeas2,time2,X2,D2,y2] = CGRPGA(@gradX,@gradD,grady,X0,D0,y0,param);
figure(1);
hold on;
semilogy(time2,Gapz2,'DisplayName','CG-RPGA','color', 'red');
figure(2);
hold on;
semilogy(time2,infeas2,'DisplayName','CG-RPGA','color', 'red');
%% AGP algorithm (PO-PO)
[Gapz3,infeas3,time3,X3,D3,y3] = AGP(@gradX,@gradD,grady,X0,D0,y0,param);
figure(1);
hold on;
semilogy(time3,Gapz3,'DisplayName','AGP','color', 'magenta');
figure(2);
hold on;
semilogy(time3,infeas3,'DisplayName','AGP','color', 'magenta');

%% SPFW algorithm (LMO-LMO)
[Gapz4,infeas4,time4,X4,D4,y4] = SPFW(@gradX,@gradD,grady,X0,D0,y0,param);
figure(1);
semilogy(time4,Gapz4,'DisplayName','SPFW','color', 'green');
figure(2);
semilogy(time4,infeas4,'DisplayName','SPFW','color', 'green');


%% gradients with respect to D and X

function GD = gradD(D,X,y)
global A_u A_l X_l;
[m,q] = size(D);
[~,n] = size(A_l);
[~,n_u] = size(X);
GD = zeros(m,q);
for i = 1:n_u
    GD = GD + (D*X(:,i)-A_u(:,i))*X(:,i)'/n_u;
end
for i = 1:n
    GD = GD + y*(D*X_l(:,i)-A_l(:,i))*X_l(:,i)'/n;
end
end

function GX = gradX(D,X,y)
global A_u;
GX = [];
[~,n] = size(X);
for i = 1:n
    GX = [GX,D'*(D*X(:,i)-A_u(:,i))/n];
end
end